-- MOD per DCS WORLD by Markindel and Cadarth
-- HMS Hood (pennant number 51) was the last battlecruiser built for the Royal Navy
-- Ship WWII HMS Hood
-- link: https://en.wikipedia.org/wiki/HMS_Hood

-----             Cartella Shapes --------------------------------------------------
mount_vfs_model_path	(current_mod_path.."/Shapes/")

-----             Cartella Textures ---------------------------------------------------
mount_vfs_texture_path  (current_mod_path.."/Textures/")
mount_vfs_texture_path  (current_mod_path.."/Textures/Hood.zip")


GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "Hood"
GT.visual.shape_dstr = ""

----------------------------------------------------------------------
----------------------------------------------------------------------

GT.animation_arguments.radar1_rotation = 11; --   1
GT.radar1_period = 3;
GT.animation_arguments.radar2_rotation = -1; --   2 
GT.animation_arguments.radar3_rotation = -1; --   3 
GT.animation_arguments.luna_lights = -1;


GT.life = 6000
GT.mass = 7.25e+006
GT.max_velocity = 55,6
GT.race_velocity = 40
GT.economy_velocity = 30
GT.economy_distance = 1.59272e+007
GT.race_distance = 1.59272e+007
GT.shipLength = 251
GT.Width = 36
GT.Height = 25.6
GT.Length = 106.2
GT.DeckLevel = 7.2

GT.X_nose = 125.0000
GT.X_tail = -123.000

GT.Tail_Width = 11
GT.Gamma_max = 0.35
GT.Om = 0.05
GT.speedup = 0.1
GT.R_min = 212.4
GT.distFindObstacles = 368.6

GT.airWeaponDist = 100000
GT.airFindDist = 150000

---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra

GT.exhaust = 
{
---	[1] = { size = 0.75 , pos = {-1.0 , 22.0, 1.0 } },
	[1] = { size = 0.90 , pos = {1.0 , 26.0, 1.0 } },

 }

--- GT.Landing_Point = {-44.0, 9.93, 0.0}  ---- Valori Originali
----GT.Landing_Point = {-62.0, 4.83, 0.0}

----------------------------------------------------------------------------------------------------------------------------
--------------  Damage Model 
---------------------------------------------------------------------------------------------------------------------------
-----------  Attenzione: gli argument devono essere unici.
GT.DM = {
----- Scafo.
    { area_name = "Scafo_Prua_Dx",			area_arg = 76,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
    { area_name = "Scafo_Centrale_Dx",		area_arg = 71,	area_life = 100, area_fire = { pos = {10.0,  2.0, 13.0}, size = 1.5}},
    { area_name = "Scafo_Poppa_Dx", 		area_arg = 72,	area_life = 100, area_fire = { pos = {-112.0, 2.0, 5.0}, size = 1.5}},
    { area_name = "Scafo_Prua_Sx", 		        area_arg = 73,	area_life = 100, area_fire = { pos = {60.0, 4.0, -8.0}, size = 1.5}},
    { area_name = "Scafo_Centrale_Sx", 		area_arg = 74,	area_life = 100, area_fire = { pos = {-8.0,  2.0, -15.0}, size = 1.5}},
    { area_name = "Scafo_Poppa_Sx", 		area_arg = 75,	area_life = 100, area_fire = { pos = {-80.0, 2.0, -12.0}, size = 1.5}},
-------- Sovrastrutture	
	{ area_name = "Zona_Fumaiolo",               area_arg = 77,	area_life = 60,  area_fire = { pos = {0.5, 12.0, 0.0}, size = 2.5}},
	{ area_name = "Ponte_Poppa",	                area_arg = 78,	area_life = 80,  area_fire = { pos = {-44.0, 9.6, 0.0}, size = 0.5}},
	{ area_name = "Strutture_Poppa",           area_arg = 82,	area_life = 200, area_fire = { pos = {-35.0, 12.0, 0.0}, size = 1.5}},
	{ area_name = "Sala_Comando",	                area_arg = 83,	area_life = 150, area_fire = { pos = {30.0, 12.0, 0.0}, size = 2.5}},
		
--------- 4 Torri Binate da 380mm	
	{ area_name = "Torre_380_Anton",		area_arg = 96,	area_life = 60, area_fire = { pos = {72.0, 8.0, 0.0}, size =  1.5}},
	{ area_name = "Torre_380_Bruno",		area_arg = 98,	area_life = 60, area_fire = { pos = {60.0, 11.0, 0.0}, size =  1.5}},  
	{ area_name = "Torre_380_Cesare",		area_arg = 70,	area_life = 60, area_fire = { pos = {-70.0, 11.0, 0.0}, size = 1.5}},
	{ area_name = "Torre_380_Dora",		area_arg = 99,	area_life = 60, area_fire = { pos = {-85.0, 8.0, 0.0}, size = 1.5}},  
	
------------------ 6 Torri Binate da 150
--	{ area_name = "Torre_150_Dx_1",			area_arg = 71,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
--	{ area_name = "Torre_150_Dx_2",			area_arg = 71,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
--	{ area_name = "Torre_150_Dx_3",			area_arg = 71,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
--	{ area_name = "Torre_150_Sx_1",			area_arg = 74,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
--	{ area_name = "Torre_150_Sx_2",			area_arg = 74,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},
--	{ area_name = "Torre_150_Sx_3",			area_arg = 74,	area_life = 100, area_fire = { pos = {93.0, 4.0, 8.0}, size = 1.5}},

    { area_name = "Ponte Prua",	           	area_arg = 84,	area_life = 60, area_fire = { pos = {67.0, 11.0, 0.0}, size =  1.5}},
    { area_name = "Ponte Poppa",		    area_arg = 85,	area_life = 60, area_fire = { pos = {-72.0, 11.0, 0.0}, size = 1.5}}, 	

}


-- Source for modifications: https://en.wikipedia.org/wiki/German_battleship_Bismarck
-- ship_FlaK38 (20 mm) naval AAA weapons. Source: https://en.wikipedia.org/wiki/2_cm_Flak_30/38/Flakvierling
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_FlaK38 = {name = "2 cm FlaK 38"};
GT_t.WS_t.ship_FlaK38.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-12), math.rad(90)},
                    };
GT_t.WS_t.ship_FlaK38.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_FlaK38.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_FlaK38.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_FlaK38.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_FlaK38.reference_angle_Z = 0
GT_t.WS_t.ship_FlaK38.LN = {}
GT_t.WS_t.ship_FlaK38.LN[1] = {}
GT_t.WS_t.ship_FlaK38.LN[1].type = 3
GT_t.WS_t.ship_FlaK38.LN[1].distanceMin = 10
GT_t.WS_t.ship_FlaK38.LN[1].distanceMax = 1500 -- effective shooting with 3600 meters
GT_t.WS_t.ship_FlaK38.LN[1].max_trg_alt = 1000
GT_t.WS_t.ship_FlaK38.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_FlaK38.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_FlaK38.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_FlaK38.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_FlaK38.LN[1].PL = {}
GT_t.WS_t.ship_FlaK38.LN[1].PL[1] = {}
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].ammo_capacity = 1550;
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shell_name = {"Rh202_20_AP", "Rh202_20_HE"};
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shell_display_name = "20mm AP+HE";
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].shot_delay = 60/800 -- 3000rpm for Block 0, 4500rpm for Block 1
GT_t.WS_t.ship_FlaK38.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_FlaK38.LN[1].BR = { {pos = {3.478, 0, 0} }, }




-- Source for modifications: https://en.wikipedia.org/wiki/HMS_Hood
-- QF 2-pounder Mk VIII (40 mm Pom Pom) naval AAA weapons. Source: https://en.wikipedia.org/wiki/QF_2-pounder_naval_gun
-- Additional Source: http://www.navweaps.com/Weapons/WNBR_2pounder_m8.htm
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_QF_2_Mk_VIII = {name = "40 mm QF 2 Mk VIII"};
GT_t.WS_t.ship_QF_2_Mk_VIII.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-10), math.rad(80)},
                    };
GT_t.WS_t.ship_QF_2_Mk_VIII.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_QF_2_Mk_VIII.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_QF_2_Mk_VIII.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_QF_2_Mk_VIII.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_QF_2_Mk_VIII.reference_angle_Z = 0
GT_t.WS_t.ship_QF_2_Mk_VIII.LN = {}
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1] = {}
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].type = 3
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].distanceMin = 10
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].distanceMax = 6220 -- effective shooting
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].max_trg_alt = 3960
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].reactionTime = 1.8
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].PL = {}
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].PL[1] = {}
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].PL[1].ammo_capacity = 560;
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].PL[1].shell_name = {"QF_2_Mk_VIII_40_HE", "QF_2_Mk_VIII_40_HE_HV"};
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].PL[1].shell_display_name = "20mm AP+HE";
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].PL[1].shot_delay = 60/115 -- 115 rpm
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_QF_2_Mk_VIII.LN[1].BR = { {pos = {3.478, 0, 0} }, }


-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 101.6mm
-------------------------------------------------------------------------------------------------

-- QF 4 inch Mk XVI (101.6 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/QF_4_inch_Mk_XVI_naval_gun
-- Used default Mark 15 CIWS Phalanx Block 1 weapon system as template with alterations
GT_t.WS_t.ship_QF_4_Mk_XVI = {name = "QF 4 inch Mk XVI"};
GT_t.WS_t.ship_QF_4_Mk_XVI.angles = {
                    {math.rad(180), math.rad(-180), math.rad(-10), math.rad(80)},
                    };
GT_t.WS_t.ship_QF_4_Mk_XVI.omegaY = math.rad(115) -- Block 1B
GT_t.WS_t.ship_QF_4_Mk_XVI.omegaZ = math.rad(116) -- Block 1B
GT_t.WS_t.ship_QF_4_Mk_XVI.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_QF_4_Mk_XVI.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.ship_QF_4_Mk_XVI.reference_angle_Z = 0
GT_t.WS_t.ship_QF_4_Mk_XVI.LN = {}
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1] = {}
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].type = 3
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].distanceMin = 10
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].distanceMax = 18150 -- effective shooting
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].max_trg_alt = 11890 -- effective shooting
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].reactionTime = 3
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].beamWidth = math.rad(1);
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].sensor, GT_t.WSN_t[3])
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].PL = {}
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].PL[1] = {}
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].PL[1].ammo_capacity = 240; -- Currently uses same ammo count as SK_C_38
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].PL[1].shell_name = {"QF_4_Mk_XVI_101_HE"};
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].PL[1].shell_display_name = "101mm HE";
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].PL[1].shot_delay = 60/17.5; -- (17.5 rounds per minute per barrel - average)
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].PL[1].reload_time = 1000000; -- never during the mission (ship autogun)
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].PL[1].automaticLoader = false;
GT_t.WS_t.ship_QF_4_Mk_XVI.LN[1].BR = { {pos = {3.478, 0, 0} }, }

--[[
-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 150mm
-------------------------------------------------------------------------------------------------
-- SK_C_28 (150 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/15_cm_SK_C/28
-- Used default FMC5 MK45 127mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_SK_C_28 = {name = "15 cm SK C/28"}
GT_t.WS_t.ship_SK_C_28.angles = {
					{math.rad(135), math.rad(-135), math.rad(-10), math.rad(40)},
					};
GT_t.WS_t.ship_SK_C_28.omegaY = 0.6
GT_t.WS_t.ship_SK_C_28.omegaZ = 0.6
GT_t.WS_t.ship_SK_C_28.reference_angle_Z = 0
GT_t.WS_t.ship_SK_C_28.LN = {}
GT_t.WS_t.ship_SK_C_28.LN[1] = {}
GT_t.WS_t.ship_SK_C_28.LN[1].type = 6
GT_t.WS_t.ship_SK_C_28.LN[1].xc = 3
GT_t.WS_t.ship_SK_C_28.LN[1].distanceMin = 50
GT_t.WS_t.ship_SK_C_28.LN[1].max_trg_alt = 7500
GT_t.WS_t.ship_SK_C_28.LN[1].reactionTime = 15
GT_t.WS_t.ship_SK_C_28.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_SK_C_28.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_SK_C_28.LN[1].PL = {}
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1] = {}
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].ammo_capacity = 240 -- Currently uses same ammo count as SK_C_38
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].shell_name = {"MK45_127"}; -- Currently uses MK45 127 mm shells (150 mm ammo is WIP)
GT_t.WS_t.ship_SK_C_28.LN[1].PL[1].shot_delay = 60/7.5 -- (7.5 rounds per minute per barrel)
GT_t.WS_t.ship_SK_C_28.LN[1].automaticLoader = false;
GT_t.WS_t.ship_SK_C_28.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_SK_C_28.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }
--]]

-------------------------------------------------------------------------------------------------
--   Descrizione Cannoni da 381mm
-------------------------------------------------------------------------------------------------
-- BL 15 inch Mk I (381 mm) naval artillery weapons. Source: https://en.wikipedia.org/wiki/BL_15_inch_Mk_I_naval_gun
-- Used default AK130 130mm Navy artillery weapon system as template with alterations
GT_t.WS_t.ship_BL_15_Mk_I = {name = "BL 15 inch Mk I"}
GT_t.WS_t.ship_BL_15_Mk_I.angles = {
					{math.rad(140), math.rad(-140), math.rad(-5), math.rad(30)},
					};
GT_t.WS_t.ship_BL_15_Mk_I.omegaY = 0.6
GT_t.WS_t.ship_BL_15_Mk_I.omegaZ = 0.6
GT_t.WS_t.ship_BL_15_Mk_I.reference_angle_Z = 0
GT_t.WS_t.ship_BL_15_Mk_I.LN = {}
GT_t.WS_t.ship_BL_15_Mk_I.LN[1] = {}
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].type = 6
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].distanceMin = 50
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].max_trg_alt = 20
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].reactionTime = 15
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.ship_BL_15_Mk_I.LN[1].sensor, GT_t.WSN_t[10])
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].PL = {}
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].PL[1] = {}
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].PL[1].ammo_capacity = 240
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].PL[1].shell_name = {"A222_130"}; -- Currently uses A222 130 mm shells (380 mm ammo is WIP)
--GT_t.WS_t.ship_BL_15_Mk_I.LN[1].PL[1].shell_name = {"Shell_381mm"};

GT_t.WS_t.ship_BL_15_Mk_I.LN[1].PL[1].shot_delay = 60/2 -- (2 rounds per minute per barrel)
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].automaticLoader = false;
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].reload_time = 240 * 20
GT_t.WS_t.ship_BL_15_Mk_I.LN[1].BR = { {pos = {8, 0, 0.1} }, {pos = {8, 0, -0.1} } }

-- weapon systems
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102

---------------------------------------------------------------------------------------------------
--               4 Torri Principali da 381 mm
---------------------------------------------------------------------------------------------------
-- 2 Torrette di Prua
--------------  Torretta Cannone di Prua 1 --------------------------------------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_BL_15_Mk_I )
GT.WS[ws].area = 'Torre_380_Anton'
GT.WS[ws].center = 'CENTER_TOWER_01'
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;  
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hood_1_1',
		recoilArgument = 133,
	},
	{
		connector_name = 'POINT_Hood_1_2',
		recoilArgument = 133,
	}
}



-----------------------------------------------------------------------------------
-------------  Torretta Cannone di Prua 2 

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_BL_15_Mk_I )
GT.WS[ws].area = 'Torre_380_Bruno'
GT.WS[ws].center = 'CENTER_TOWER_02'
GT.WS[ws].drawArgument1 = 13 ---- Rotazione
GT.WS[ws].drawArgument2 = 14 ---- Alzo
GT.WS[ws].angles[1][1] = math.rad(140);
GT.WS[ws].angles[1][2] = math.rad(-140);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hood_2_1',
		recoilArgument = 34,
	},
	{
		connector_name = 'POINT_Hood_2_2',
		recoilArgument = 34,
	}
}


----------------------------------------------------------------------
-- 2 Torrette di Poppa
----------------------------------------------------------------------
-------------  Torretta Cannone di Poppa 3 ---------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_BL_15_Mk_I )
GT.WS[ws].area = 'Torre_380_Cesare'
GT.WS[ws].center = 'CENTER_TOWER_03'
GT.WS[ws].drawArgument1 = 15
GT.WS[ws].drawArgument2 = 16
GT.WS[ws].angles[1][1] = math.rad(-45);
GT.WS[ws].angles[1][2] = math.rad(45);
GT.WS[ws].reference_angle_Y = math.rad(-180);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.5;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hood_3_1',
		recoilArgument = 35,
	},
	{
		connector_name = 'POINT_Hood_3_2',
		recoilArgument = 35,
	}
}


-------------------------------------------------------------------------
-------------  Torretta Cannone di Poppa 4 ---------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_BL_15_Mk_I )
GT.WS[ws].area = 'Torre_380_Dora'
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 17
GT.WS[ws].drawArgument2 = 18
GT.WS[ws].angles[1][1] = math.rad(-45);             ---- verso sx
GT.WS[ws].angles[1][2] = math.rad(45);            ---- verso dx
GT.WS[ws].reference_angle_Y = math.rad(-180);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_Hood_4_1',
		recoilArgument = 36,
	},
	{
		connector_name = 'POINT_Hood_4_2',
		recoilArgument = 36,
	}
}




-----------------------------------------------------------------------------------
--  7 torrette laterali
----------------------------------------------------------------------------------
---- 1 Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_05'
GT.WS[ws].drawArgument1 = 19     ---------- rotazione
GT.WS[ws].drawArgument2 = 20    ----------  alzo
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(10);
GT.WS[ws].reference_angle_Y = math.rad(35);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_GUN_1_1',
		recoilArgument = 137,
	},
	{
		connector_name = 'POINT_GUN_1_2',
		recoilArgument = 137,
	}
}

----2 Dx 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_06'
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
GT.WS[ws].angles[1][1] = math.rad(-10);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-35);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_GUN_2_1',
		recoilArgument = 138,
	},
	{
		connector_name = 'POINT_GUN_2_2',
		recoilArgument = 138,
	}
}

---- 3 Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_07'
GT.WS[ws].drawArgument1 = 23
GT.WS[ws].drawArgument2 = 24
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(10);
GT.WS[ws].reference_angle_Y = math.rad(35);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_GUN_3_1',
		recoilArgument = 139,
	},
	{
		connector_name = 'POINT_GUN_3_2',
		recoilArgument = 139,
	}
}

----4 Dx 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_08'
GT.WS[ws].drawArgument1 = 25
GT.WS[ws].drawArgument2 = 26
GT.WS[ws].angles[1][1] = math.rad(-10);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-35);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_GUN_4_1',
		recoilArgument = 140,
	},
	{
		connector_name = 'POINT_GUN_4_2',
		recoilArgument = 140,
	}
}

---- 5 Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_09'
GT.WS[ws].drawArgument1 = 27
GT.WS[ws].drawArgument2 = 28
GT.WS[ws].angles[1][1] = math.rad(150);
GT.WS[ws].angles[1][2] = math.rad(50);
GT.WS[ws].reference_angle_Y = math.rad(135);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_GUN_5_1',
		recoilArgument = 141,
	},
	{
		connector_name = 'POINT_GUN_5_2',
		recoilArgument = 141,
	}
}

----6 Dx 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_10'
GT.WS[ws].drawArgument1 = 29
GT.WS[ws].drawArgument2 = 30
GT.WS[ws].angles[1][1] = math.rad(-50);
GT.WS[ws].angles[1][2] = math.rad(-150);
GT.WS[ws].reference_angle_Y = math.rad(-135);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_GUN_6_1',
		recoilArgument = 142,
	},
	{
		connector_name = 'POINT_GUN_6_2',
		recoilArgument = 142,
	}
}


----7 Centrale Poppa
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_4_Mk_XVI )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_11'
GT.WS[ws].drawArgument1 = 31
GT.WS[ws].drawArgument2 = 32
GT.WS[ws].angles[1][1] = math.rad(-70);
GT.WS[ws].angles[1][2] = math.rad(70);
GT.WS[ws].reference_angle_Y = math.rad(-135);
GT.WS[ws].LN[1].BR[1].recoilTime = 1.0;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_GUN_7_1',
		recoilArgument = 143,
	},
	{
		connector_name = 'POINT_GUN_7_2',
		recoilArgument = 143,
	}
}





----------------------------------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------------------------------
---------- ***************   Mitragliatrici Leggere con 4 canne (7 in totale)  ****************------------------------
---------------------------------------------------------------------------------------------------------------------------------

-- Machineguns M2 .50cal   Prua Sinistra 1
--------------------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_12'
GT.WS[ws].drawArgument1 = 33
GT.WS[ws].drawArgument2 = 34
GT.WS[ws].angles = {
{math.rad(170), math.rad(10), math.rad(-10), math.rad(80)},
};
GT.WS[ws].reference_angle_Y = math.rad(90); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 122;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MQ_1_1',
		recoilArgument = 122,
	},
	{
		connector_name = 'POINT_MQ_1_2',
		recoilArgument = 122,
	},
		{
		connector_name = 'POINT_MQ_1_3',
		recoilArgument = 122,
	},
	{
		connector_name = 'POINT_MQ_1_4',
		recoilArgument = 122,
	}
}


---------------------------------------------------------------------------------------------------------------------------------
-- Machineguns M2 .50cal   Prua Destra 2 
--------------------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_13'
GT.WS[ws].drawArgument1 = 35
GT.WS[ws].drawArgument2 = 36
GT.WS[ws].angles = {
{math.rad(-10), math.rad(-170), math.rad(-10), math.rad(80)},
};
GT.WS[ws].reference_angle_Y = math.rad(-90); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 123;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MQ_2_1',
		recoilArgument = 123,
	},
	{
		connector_name = 'POINT_MQ_2_2',
		recoilArgument = 123,
	},
		{
		connector_name = 'POINT_MQ_2_3',
		recoilArgument = 123,
	},
	{
		connector_name = 'POINT_MQ_2_4',
		recoilArgument = 123,
	}
}

---------------------------------------------------------------------------------------------------------------------------------
-- Machineguns M2 .50cal   Sinistra 3
--------------------------------------

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_14'
GT.WS[ws].drawArgument1 = 37
GT.WS[ws].drawArgument2 = 38
GT.WS[ws].angles = {
{math.rad(170), math.rad(10), math.rad(-10), math.rad(80)},
};
GT.WS[ws].reference_angle_Y = math.rad(90); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 124;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MQ_3_1',
		recoilArgument = 124,
	},
	{
		connector_name = 'POINT_MQ_3_2',
		recoilArgument = 124,
	},
		{
		connector_name = 'POINT_MQ_3_3',
		recoilArgument = 124,
	},
	{
		connector_name = 'POINT_MQ_3_4',
		recoilArgument = 124,
	}
}


---------------------------------------------------------------------------------------------------------------------------------
-- Machineguns M2 .50cal   Prua Sinistra  4
ws = GT_t.inc_ws(); 
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_15'
GT.WS[ws].drawArgument1 = 39
GT.WS[ws].drawArgument2 = 40
GT.WS[ws].angles = {
{math.rad(-10), math.rad(-170), math.rad(-10), math.rad(80)},
};
GT.WS[ws].reference_angle_Y = math.rad(-90); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 125;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MQ_4_1',
		recoilArgument = 125,
	},
	{
		connector_name = 'POINT_MQ_4_2',
		recoilArgument = 125,
	},
		{
		connector_name = 'POINT_MQ_4_3',
		recoilArgument = 125,
	},
	{
		connector_name = 'POINT_MQ_4_4',
		recoilArgument = 125,
	}
}

---------------------------------------------------------------

---------------------------------------------------------------------------------------------------------------------------------
------  1  Mitragliatrice Quadrinata di Poppa
---------------------------------------------------------------------------------------------------------------------------------
--- Mitragliatrice M2 .50cal di Poppa Centrale 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Strutture_Poppa'
GT.WS[ws].center = 'CENTER_TOWER_16'
GT.WS[ws].drawArgument1 = 41
GT.WS[ws].drawArgument2 = 42
--GT.WS[ws].angles = {
--{math.rad(-45), math.rad(45), math.rad(-10), math.rad(80)},
--};
GT.WS[ws].angles = {
					{math.rad(-45), math.rad(45), math.rad(-12), math.rad(87)},
					{math.rad(45), math.rad(-45), math.rad(35), math.rad(87)},
					};
GT.WS[ws].reference_angle_Y = math.rad(180); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 126;
GT.WS[ws].LN[1].BR = 
{
	{
		connector_name = 'POINT_MQ_5_1',
		recoilArgument = 126,
	},
	{
		connector_name = 'POINT_MQ_5_2',
		recoilArgument = 126,
	},
		{
		connector_name = 'POINT_MQ_5_3',
		recoilArgument = 126,
	},
	{
		connector_name = 'POINT_MQ_5_4',
		recoilArgument = 126,
	}
}


----------------------------------------------------------------------------------------------------------------------------------
----        Mitragliatrici Singole
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Machineguns M2 .50cal   Singole 1 Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_17'
GT.WS[ws].drawArgument1 = 43
GT.WS[ws].drawArgument2 = 44
GT.WS[ws].angles = {
{math.rad(170), math.rad(-10), math.rad(-10), math.rad(80)},
};
GT.WS[ws].reference_angle_Y = math.rad(0); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 127;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MiniGun_01'

-- Machineguns M2 .50cal   Singole 2 Dx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Sala_Comando'
GT.WS[ws].center = 'CENTER_TOWER_18'
GT.WS[ws].drawArgument1 = 45
GT.WS[ws].drawArgument2 = 46
GT.WS[ws].angles = {
{math.rad(-170), math.rad(10), math.rad(-10), math.rad(80)},
};
GT.WS[ws].reference_angle_Y = math.rad(0); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 128;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MiniGun_02'

-- Machineguns M2 .50cal   Singole 3 Sx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_19'
GT.WS[ws].drawArgument1 = 47
GT.WS[ws].drawArgument2 = 48
GT.WS[ws].angles = {
{math.rad(170), math.rad(-10), math.rad(-10), math.rad(80)},
};
GT.WS[ws].reference_angle_Y = math.rad(90); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 129;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MiniGun_03'

-- Machineguns M2 .50cal   Singole 4 Dx
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_QF_2_Mk_VIII )
GT.WS[ws].area = 'Zona_Fumaiolo'
GT.WS[ws].center = 'CENTER_TOWER_20'
GT.WS[ws].drawArgument1 = 49
GT.WS[ws].drawArgument2 = 50
GT.WS[ws].angles = {
{math.rad(-10), math.rad(-170), math.rad(-10), math.rad(80)},
};
GT.WS[ws].reference_angle_Y = math.rad(-90); 
GT.WS[ws].LN[1].BR[1].recoilTime = 1;
GT.WS[ws].LN[1].fireAnimationArgument = 130;
GT.WS[ws].LN[1].BR[1].connector_name = 'POINT_MiniGun_04'


----------------------------------------------------------------------------------------------------------------------------------
----        Parte Finale
----------------------------------------------------------------------------------------------------------------------------------


GT.Name = "Hood"
GT.DisplayName = _("HMS Hood")
GT.Rate = 6000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
                RADAR = {
                    "Patriot str",
                    "ticonderoga search radar",
                }
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";
---GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,TICONDEROGA,
GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,
                    "Cruisers",
                    "RADAR_BAND1_FOR_ARM",
                    "DetectionByAWACS",
				};
GT.Categories = {
					{name = "Armed Ship"},
----					{name = "HelicopterCarrier"}
				};

GT.Countries = { "UK",};	
	
add_surface_unit(GT)				